'\" Copyright 1991 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /home/srilm/CVS/srilm/misc/doc/Opt.man,v 1.4 1991/01/28 17:00:56 kupfer Exp $ SPRITE (Berkeley)
'/" 
.so \*(]ltmac.sprite
.HS Opt lib
.BS
.SH NAME
Opt_Parse, Opt_PrintUsage \- Manage command line options
.SH SYNOPSIS
\fB#include <option.h>\fR
.sp
int
\fBOpt_Parse\fR(\fIargc, argv, optionArray, numOptions, flags\fR)
.sp
void
\fBOpt_PrintUsage\fR(\fIcommandName, optionArray, numOptions\fR)
.SH ARGUMENTS
.AS Option *optionArray
.AP int argc in
Number of arguments on command line.
.AP char **argv in/out
Command line arguments passed to main program.
.AP char *commandName in
Name of the program being run, usually \fIargv\fR[0].
.AP Option *optionArray in
An array of option descriptions.
.AP int numOptions in
Number of elements in optionArray, usually obtained using the
\fBOpt_Number\fR macro, e.g. \fBOpt_Number\fR(optionArray).
.AP int flags in
If non-zero, then it specifies one or more flags that control the
parsing of arguments.  Different flags may be OR'ed together.  The
only flags currently defined are OPT_ALLOW_CLUSTERING and OPT_OPTIONS_FIRST.  
.BE
.SH DESCRIPTION
.PP
\fBOpt_Parse\fR parses the command line arguments of a program according
to an array of option descriptions.  Starting with \fIargv\fR[1], it parses
as many options as it can and returns the rest of the options in
the \fIargv\fR array, compacted to the beginning of the array (starting
with \fIargv\fR[1]).  The return value indicates how many options are
returned in the \fIargv\fR array (including \fIargv\fR[0]).
Opt_Parse returns options that don't start with ``-'' unless they
are arguments for options that it parses.  \fBOpt_Parse\fR also returns
any options following an \fBOPT_REST\fR option (see below for more details).
.PP
Each element of the array
\fIoptionArray\fR has the following structure:
.DS
.ta 2c
\fBtypedef struct\fR Option {
    \fBint\fR	\fItype\fR;
    \fBchar\fR	*\fIkey\fR;
    \fBchar\fR	*\fIvaluePtr\fR;
    \fBchar\fR	*\fIdocMsg\fR;
} Option;
.DE
.LP
The \fIkey\fR field is a string that identifies this option.  For
example, if \fIkey\fR is \fBfoo\fR, then this Option will match
a \fB\-foo\fR command-line option.  If \fIkey\fR is the empty
string (``'') then it matches a \fB\-\fR command-line option.
If \fIkey\fR is NULL, the Option
will not match any command-line options (this feature is only useful
for OPT_DOC options).
\fIDocMsg\fR is a documentation string to print out as part of a
help message.
The \fItype\fR field determines what to do when this Option is
matched.  It also determines the meaning of the \fIvaluePtr\fR
field.  \fIType\fR should always be specified using one of the
following macros:
.TP
\fBOPT_TRUE\fR
Treats \fIvaluePtr\fR as the address of an integer, and stores
the value 1 in that integer.
.TP
\fBOPT_FALSE\fR
Treats \fIvaluePtr\fR as the address of an integer and stores
the value 0 in that integer.
.TP
\fBOPT_CONSTANT\fR(\fIvalue\fR)
This is a generalized form of OPT_TRUE and OPT_FALSE.  Treats
\fIvaluePtr\fR as the address of an integer and stores \fIvalue\fR
in that integer.  \fIValue\fR must be a positive integer.
.TP
\fBOPT_INT\fR
The next argument after the one matching \fIkey\fR must contain an
integer string in the format accepted by \fBstrtol\fR (e.g. ``0''
and ``0x'' prefixes may be used to specify octal or hexadecimal
numbers, respectively).  \fIValuePtr\fR
will be treated as the address of an integer, and the value given
by the next argument will be stored there.
.TP
\fBOPT_TIME\fR
The next argument after the one matching \fIkey\fR must contain a
string that is parsable as a date and time.  Currently, only two
formats are recognized:
.DS
\fIseconds\fR
.DE
.IP
and
.DS
\fIyy\fB.\fImm\fB.\fIdd\fB.\fIhh\fB.\fImm\fB.\fIss\fR
.DE
.IP
The first form is simply the number of seconds since the start of the
epoch (1 January 1970, 0 hours GMT).  The second form specifies the
year (e.g., 91 or 1991),
month (1-12), day of the month, hours (0-23), minutes (0-59), and
seconds (0-59).  All fields must be specified.
\fIValuePtr\fR
will be treated as the address of a
.B time_t
(defined in
.BR <time.h> ), 
and the given time will be stored there.
All times are in terms of the current timezone and daylight savings
rules.
.IP
Note that this flavor can clobber the static buffer used by the 
.B localtime
library routine.
.TP
\fBOPT_FLOAT\fR
The next argument after the one matching \fIkey\fR must contain a
floating-point number in the format accepted by \fBstrtol\fR.
\fIValuePtr\fR will be treated as the address of an double-precision
floating point value, and the
value given by the next argument will be stored there.
.TP
\fBOPT_STRING\fR
Treats \fIvaluePtr\fR as the address of a (char *), and stores a pointer
to the next argument in the location
pointed to by \fIvaluePtr\fR.
.TP
\fBOPT_DOC\fR
This option is intended primarily as a way of printing extra documentation
during help message printouts.  It isn't normally used as an actual
option (and normally its \fIkey\fR field is NULL).
If it is invoked as an option, then the same thing happens as for
the ``-?'' option:  descriptions get printed for all options in
\fIoptionArray\fR and \fBOpt_Parse\fR calls exit(0) to terminate the process.
.TP
\fBOPT_REST\fR
This option is used by programs that allow the last several of their
options to be the name and/or options for some other program.  If
an \fBOPT_REST\fR option is found, then \fBOpt_Parse\fR doesn't process any
of the remaining arguments;  it returns them all at the beginning of \fIargv\fR.
In addition, \fBOpt_Parse\fR treats \fIvaluePtr\fR as the address of an
integer value, and stores in that value the index of the first of the
\fBOPT_REST\fR options in the returned \fIargv\fR.  This allows the
program to distinguish the \fBOPT_REST\fR options from other
unprocessed options that preceeded the \fBOPT_REST\fR.
.TP
\fBOPT_FUNC\fR
When one of these options is encountered, \fIvaluePtr\fR is treated
as the address of a function which is then called
with the following calling sequence:
.DS
.ta 1c 2c 3c 4c 5c 6c
\fBint\fI
func(optString, nextArg)
    \fBchar\fR	*\fIoptString\fR;
    \fBchar\fR	*\fInextArg\fR;
{
}
.DE
.IP
The \fIoptString\fR parameter points to the current option, and
\fInextArg\fR points to the next option from \fIargv\fR (or NULL
if there aren't any more options in \fIargv\fR.  If \fIfunc\fR
uses \fInextArg\fR as an argument to the current option (so that
Opt_Parse should skip it), then it should return 1.  Otherwise it
should return 0.
.TP
\fBOPT_GENFUNC\fR
Treat \fIvaluePtr\fR as the address of a function and pass all of the
remaining arguments to it in the following way:
.DS
.ta 1c 2c 3c 4c 5c 6c
\fBint\fI
genfunc(optString, argc, argv)
    \fBchar\fR	*\fIoptString\fR;
    \fBint\fR	\fIargc\fR;
    \fBchar\fR	**\fIargv\fR;
{
}
.DE
.IP
\fIArgc\fR and \fIargv\fR refer to all of the options after the
one that triggered the call, and \fIoptString\fR points to the
triggering option.  \fIGenfunc\fR should behave in a fashion similar
to \fBOpt_Parse\fR:  parse as many of the remaining arguments as it can,
then return any that are left by compacting them to the beginning of
\fIargv\fR (starting at \fIargv\fR[0]).  \fIGenfunc\fR
should return a count of how many arguments are left in \fIargv;
\fBOpt_Parse\fR will process them.

.SH "FLAGS"
.IP \fBOPT_ALLOW_CLUSTERING\fR
This will
permit several options to be clustered together with a
single ``-'', e.g., ``foo -abc'' will be handled the same way as
``foo -a -b -c''.  OPT_ALLOW_CLUSTERING is likely to cause confusing
behavior unless each option is identified with a single character.
.IP \fBOPT_OPTIONS_FIRST\fR
This causes \fBOpt_Parse\fR to stop parsing the command line anytime something
that is not an option is detected.  Thus, a program that takes some options 
followed by a command to execute (along with that command's options) can 
parse its own options using OPT_OPTIONS_FIRST.  When the command to execute is 
encountered, assuming it does not begin with a hyphen, \fBOpt_Parse\fR will 
return the command and its arguments starting at \fIargv\fR[1], ignoring
any arguments with hyphens following the first non-option.
.SH "USAGE MESSAGE"
.PP
\fBOpt_PrintUsage\fR may be invoked to print out all the documentation strings
(plus option names and default values) for a command's options.  If
\fBOpt_Parse\fR encounters an option ``-?'' or ``-help'', then it will call
\fBOpt_PrintUsage\fR
and exit.  Note:  in some shells the question-mark must be escaped
(e.g., ``foo -\e?'' in \fIcsh\fR).

.SH EXAMPLE
.PP
Here is an example definition of a set of option descriptions and
some sample command lines that use the options.  Note the effect
on argc and argv;  command arguments that get interpreted as
options or option values are eliminated from argv, and argc
is updated to reflect reduced number of arguments.
.DS
/*
 * Define and set default values for globals.
 */
Boolean debugFlag = FALSE;
int numReps = 100;
char defaultFileName[] = "out";
char *fileName = defaultFileName;
Boolean exec = FALSE;

/*
 * Define option descriptions.
 */
Option optionArray[] = {
    OPT_TRUE, "X", (char *) &debugFlag, "Turn on debugging printfs",
    OPT_INT, "N", (char *) &numReps, "Number of repetitions",
    OPT_STRING, "of", (char *) &fileName, "Output filename",
    OPT_REST, "x", (char *) &exec,
        "File to exec, followed by any arguments (must be last argument).",
};

main(argc, argv)
    int argc;
    char *argv[];
{
    Opt_Parse(argc, argv, optionArray, Opt_Number(optionArray),
            OPT_ALLOW_CLUSTERING);

    /*
     * the rest of the program.
     */
}
.DE
.PP
Note that default values can be assigned to option variables.
Also, numOptions gets calculated by the compiler in this example.
Here are some example command lines and their effects.
.DS
prog -N 200 infile		# just sets the numReps variable to 200
prog -of out200 infile 	# sets fileName to reference "out200"
prog -XN 10 infile		# sets the debug flag, also sets numReps
.DE
In all of the above examples, the return value from Opt_Parse will be 2,
\fIargv\fR[0] will be ``prog'', \fIargv\fR[1] will be ``infile'',
and \fIargv\fR[2] will be NULL.

.SH KEYWORDS
arguments, command line, options
